//
//  DetailInterfaceController.swift
//  dismissController
//
//  Created by yoshiyuki oshige on 2015/04/01.
//  Copyright (c) 2015年 yoshiyuki oshige. All rights reserved.
//

import WatchKit
import Foundation


// Swichの設定値
var isOn:Bool = true

class DetailInterfaceController: WKInterfaceController {
    // Switchのテンポラリな設定値
    var tempIsOn:Bool?
    
    // SwitchとOutlet接続する
    @IBOutlet weak var mySwitch: WKInterfaceSwitch!
    
    // SwitchとAction接続する
    @IBAction func tapSwitch(value: Bool) {
        // Switchの設定値が変化したら一時的に保存する
        tempIsOn = value
    }
    
    // OKボタンとAction接続する
    @IBAction func tapOk() {
        // tempIsOnがnilでなければ変数isOnに設定値を保存する
        if let on = tempIsOn {
            isOn = on
        }
        // 詳細ページを閉じる
        dismissController()
    }

    override func awakeWithContext(context: AnyObject?) {
        super.awakeWithContext(context)
        
        // Configure interface objects here.
    }

    
    override func willActivate() {
        // This method is called when watch view controller is about to be visible to user
        super.willActivate()
        // ページが開いたならばSwitchの値を設定する
        mySwitch.setOn(isOn)
    }

    override func didDeactivate() {
        // This method is called when watch view controller is no longer visible
        super.didDeactivate()
    }

}
